/*
 * Examples  : Arduino Examples By....ETT CO.,LTD
 * Program   : SMS_Send
 * Software  : Arduino 1.0.5 r2
 * Hardware  : ET-BASE AVR EASY32U4 + ET-3G UC20 
 * Function  : Send SMS to your phone number
 */
 
int led = 13;                          // LED D13
char phone_number[] = "XXXXXXXXXX";    // Your phone number  Example. 089xxxxxxx

void setup() 
{ 
  Serial1.begin(115200);               // Set RS232 115200 bps
  delay(5000);
  
  Serial1.print("AT+CMGF=1\r");        // Select SMS message format to text mode                 
  CheckOK();                           // Check "OK" 
  
  Serial1.print("AT+CSMP=17,167,0,0\r");        // Set SMS Text Mode Parameters                 
  CheckOK();                                    // Check "OK" 
  
  Serial1.print("AT+CSCS=\"GSM\"\r");           // Select TE Character Set                
  CheckOK();                                    // Check "OK"

  Serial1.print("AT+CMGS=\"");                  // Send to your phone number          
  Serial1.print(phone_number);
  Serial1.print("\"\r");
 
  CheckReady();                                // Check ">"
  Serial1.print("Hello from ET-3G UC20");      // SMS body    
  delay(100);
  Serial1.write(0x1A);                         // Ctrl+Z    
} 
  
void loop() 
{ 
  digitalWrite(led, HIGH);   
  delay(500);               
  digitalWrite(led, LOW);    
  delay(500);  
} 

void CheckOK()
{
  while(Serial1.read()!='K');          // Check "OK" 
  delay(100);  
}

void CheckReady()
{
  while(Serial1.read()!='>');          // Check ">" 
  delay(100);  
}
